/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class MengerSpongeBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
AddMineableHoe {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83124_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)6.0), (VoxelShape[])new VoxelShape[]{MengerSpongeBlock.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)16.0), Shapes.m_83110_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), (VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0)), Shapes.m_83110_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0), (VoxelShape)MengerSpongeBlock.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0)), Shapes.m_83110_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape)MengerSpongeBlock.m_49796_((double)10.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Shapes.m_83110_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0), (VoxelShape)MengerSpongeBlock.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0)), Shapes.m_83110_((VoxelShape)MengerSpongeBlock.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape)MengerSpongeBlock.m_49796_((double)10.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0))}), (VoxelShape[])new VoxelShape[0]);

    public MengerSpongeBlock() {
        super(FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50056_).m_60955_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (this.absorbWater((LevelAccessor)world, pos)) {
            world.m_46597_(pos, EndBlocks.MENGER_SPONGE_WET.m_49966_());
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.absorbWater(world, pos)) {
            return EndBlocks.MENGER_SPONGE_WET.m_49966_();
        }
        return state;
    }

    private boolean absorbWater(LevelAccessor world, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple pair = (Tuple)queue.poll();
            BlockPos blockPos = (BlockPos)pair.m_14418_();
            int j = (Integer)pair.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockPos2 = blockPos.m_121945_(direction);
                BlockState blockState = world.m_8055_(blockPos2);
                FluidState fluidState = world.m_6425_(blockPos2);
                if (!fluidState.m_205070_(FluidTags.f_13131_)) continue;
                if (blockState.m_60734_() instanceof BucketPickup && !((BucketPickup)blockState.m_60734_()).m_142598_(world, blockPos2, blockState).m_41619_()) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
                    continue;
                }
                if (blockState.m_60734_() instanceof LiquidBlock) {
                    world.m_7731_(blockPos2, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
                    continue;
                }
                if (!blockState.m_204336_(CommonBlockTags.WATER_PLANT)) continue;
                BlockEntity blockEntity = blockState.m_155947_() ? world.m_7702_(blockPos2) : null;
                MengerSpongeBlock.m_49892_((BlockState)blockState, (LevelAccessor)world, (BlockPos)blockPos2, (BlockEntity)blockEntity);
                world.m_7731_(blockPos2, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }
}

